% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlaps}
\alias{overlaps}
\alias{overlap}
\alias{exact}
\alias{reverse}
\alias{across}
\alias{chain}
\alias{aligns_start}
\alias{aligns_end}
\alias{inbetween}
\alias{overlap_method}
\alias{include_overlap_method}
\alias{exclude_overlap_method}
\title{Overlapping number line objects}
\usage{
overlaps(x, y, methods = "overlap", method = "overlap")

overlap(x, y)

exact(x, y)

reverse(x, y)

across(x, y)

chain(x, y)

aligns_start(x, y)

aligns_end(x, y)

inbetween(x, y)

overlap_method(x, y)

include_overlap_method(methods)

exclude_overlap_method(methods)
}
\arguments{
\item{x}{\code{number_line} object.}

\item{y}{\code{number_line} object.}

\item{methods}{Methods of overlap. Check different pairs of \code{number_line} objects by different \code{methods}. Options are \code{"exact"}, \code{"reverse"}, \code{"inbetween"}, \code{"across"}, \code{"chain"}, \code{"aligns_start"} and \code{"aligns_end"}.}

\item{method}{Deprecated. Please use \code{methods} instead. Method of overlap. Check every pair of \code{number_line} objects by the same \code{method}.}
}
\value{
\code{logical}; \code{character}
}
\description{
Identify overlapping \code{number_line} objects
}
\details{
\bold{8 logical test;}

\bold{\code{exact()}} - Identical left and right points.

\bold{\code{reverse()}} - Swapped left and right points.

\bold{\code{inbetween()}} - start and endpoints of one \code{number_line} object is within the start and endpoints of another.

\bold{\code{across()}} - start or endpoints of one \code{number_line} object is within the start and endpoints of another.

\bold{\code{chain()}} - endpoint of one \code{number_line} object is the same as the start point of another.

\bold{\code{aligns_start()}} - identical start points only.

\bold{\code{aligns_end()}} - identical endpoints only.

\bold{\code{overlap()}} - any kind of overlap. A convenient \code{method} for "ANY" and "ALL" methods of overlap.

\bold{\code{overlaps()}} - overlap by any set of the 7 methods above.

\bold{Describe methods of overlap;}

\bold{\code{overlap_method()}} - Shows if and how a pair of \code{number_line} object have overlapped.
Does not show \code{"overlap"} since \bold{\code{overlap()}} is always \code{TRUE} when any other method is \code{TRUE}.

\bold{\code{include_overlap_method()}} and \bold{\code{exclude_overlap_method()}} - Conveniently create the required values for \code{methods} and \code{overlap_methods} in \code{\link{episodes}}.
}
\examples{
a <- number_line(-100, 100)
b <- number_line(10, 11.2)
c <- number_line(100, 200)
d <- number_line(100, 120)
e <- number_line(50, 120)
g <- number_line(100, 100)
f <- number_line(120, 50)

overlaps(a, g)
overlaps(a, g, methods = "exact|chain")

overlap(a, b)
overlap(a, e)

exact(a, g)
exact(a, a)

reverse(e, e)
reverse(e, f)

across(a, b)
across(a, e)

chain(c, d)
chain(a, c)

aligns_start(c, d)
aligns_start(a, c)

aligns_end(d, e)
aligns_end(a, c)

inbetween(a, g)
inbetween(b, a)

overlap_method(a, c)
overlap_method(d, c)
overlap_method(a, g)
overlap_method(b, e)

include_overlap_method("across")
include_overlap_method(c("across", "chain"))

exclude_overlap_method("across")
exclude_overlap_method(c("across", "chain"))
}
\seealso{
\code{\link{number_line}} and \code{\link{set_operations}}
}
