% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointfuns.R
\name{jointfun_}
\alias{jointfun_}
\title{A minimal function which counts the number of observations by groups in a data frame}
\usage{
jointfun_(.data, .variables, ...)
}
\arguments{
\item{.data}{data frame to be processed}

\item{.variables}{variables to split data frame by, as a character vector (\code{c("var1", "var2")}).}

\item{...}{additional function calls to be applied on the .data}
}
\value{
a data frame, with a column for each cateogrical variable used, and a row for each combination of all the categorical variables' modalities.
}
\description{
A minimal function which counts the number of observations by groups in a data frame
}
\examples{
data("invented_wages")
tmp <- jointfun_(.data = invented_wages, .variables = c("gender", "sector"))
tmp
str(tmp)
}
