% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{random.LogNormal}
\alias{random.LogNormal}
\title{Draw a random sample from a LogNormal distribution}
\usage{
\method{random}{LogNormal}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{LogNormal} object created by a call to \code{\link[=LogNormal]{LogNormal()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Draw a random sample from a LogNormal distribution
}
\examples{

set.seed(27)

X <- LogNormal(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other LogNormal distribution: 
\code{\link{cdf.LogNormal}()},
\code{\link{fit_mle.LogNormal}()},
\code{\link{pdf.LogNormal}()},
\code{\link{quantile.LogNormal}()}
}
\concept{LogNormal distribution}
