% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_chisq.R
\name{dist_chisq}
\alias{dist_chisq}
\title{The (non-central) Chi-Squared Distribution}
\usage{
dist_chisq(df, ncp = 0)
}
\arguments{
\item{df}{degrees of freedom (non-negative, but can be non-integer).}

\item{ncp}{non-centrality parameter (non-negative).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Chi-square distributions show up often in frequentist settings
as the sampling distribution of test statistics, especially
in maximum likelihood estimation settings.
}
\details{
We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a \eqn{\chi^2} random variable with
\code{df} = \eqn{k}.

\strong{Support}: \eqn{R^+}, the set of positive real numbers

\strong{Mean}: \eqn{k}

\strong{Variance}: \eqn{2k}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{1}{\sqrt{2 \pi \sigma^2}} e^{-(x - \mu)^2 / 2 \sigma^2}
  }{
    f(x) = 1 / (2 \pi \sigma^2) exp(-(x - \mu)^2 / (2 \sigma^2))
  }

\strong{Cumulative distribution function (c.d.f)}:

The cumulative distribution function has the form

\deqn{
    F(t) = \int_{-\infty}^t \frac{1}{\sqrt{2 \pi \sigma^2}} e^{-(x - \mu)^2 / 2 \sigma^2} dx
  }{
    F(t) = integral_{-\infty}^t 1 / (2 \pi \sigma^2) exp(-(x - \mu)^2 / (2 \sigma^2)) dx
  }

but this integral does not have a closed form solution and must be
approximated numerically. The c.d.f. of a standard normal is sometimes
called the "error function". The notation \eqn{\Phi(t)} also stands
for the c.d.f. of a standard normal evaluated at \eqn{t}. Z-tables
list the value of \eqn{\Phi(t)} for various \eqn{t}.

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{\mu t + \sigma^2 t^2 / 2}
  }{
    E(e^(tX)) = e^(\mu t + \sigma^2 t^2 / 2)
  }
}
\examples{
dist <- dist_chisq(df = c(1,2,3,4,6,9))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Chisquare]{stats::Chisquare}
}
