% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_logarithmic.R
\name{dist_logarithmic}
\alias{dist_logarithmic}
\title{The Logarithmic distribution}
\usage{
dist_logarithmic(prob)
}
\arguments{
\item{prob}{parameter. \code{0 <= prob < 1}.}
}
\description{
\lifecycle{stable}
}
\examples{
dist <- dist_logarithmic(prob = c(0.33, 0.66, 0.99))
dist

\dontshow{if (requireNamespace("actuar", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[actuar:Logarithmic]{actuar::Logarithmic}
}
