% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_hypergeometric.R
\name{dist_hypergeometric}
\alias{dist_hypergeometric}
\title{The Hypergeometric distribution}
\usage{
dist_hypergeometric(m, n, k)
}
\arguments{
\item{m}{The number of type I elements available.}

\item{n}{The number of type II elements available.}

\item{k}{The size of the sample taken.}
}
\description{
\lifecycle{stable}
}
\details{
To understand the HyperGeometric distribution, consider a set of
\eqn{r} objects, of which \eqn{m} are of the type I and
\eqn{n} are of the type II. A sample with size \eqn{k} (\eqn{k<r})
with no replacement is randomly chosen. The number of observed
type I elements observed in this sample is set to be our random
variable \eqn{X}.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a HyperGeometric random variable with
success probability \code{p} = \eqn{p = m/(m+n)}.

\strong{Support}: \eqn{x \in { \{\max{(0, k-n)}, \dots, \min{(k,m)}}\}}

\strong{Mean}: \eqn{\frac{km}{n+m} = kp}

\strong{Variance}: \eqn{\frac{km(n)(n+m-k)}{(n+m)^2 (n+m-1)} =
  kp(1-p)(1 - \frac{k-1}{m+n-1})}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = x) = \frac{{m \choose x}{n \choose k-x}}{{m+n \choose k}}
  }{
    P(X = x) = \frac{{m \choose x}{n \choose k-x}}{{m+n \choose k}}
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le k) \approx \Phi\Big(\frac{x - kp}{\sqrt{kp(1-p)}}\Big)
 }
}
\examples{
dist <- dist_hypergeometric(m = rep(500, 3), n = c(50, 60, 70), k = c(100, 200, 300))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Hypergeometric]{stats::Hypergeometric}
}
