\name{NormType-class}
\docType{class}
\alias{NormType-class}
\alias{name,NormType-method}
\alias{name<-,NormType-method}
\alias{fct}
\alias{fct<-}
\alias{fct,NormType-method}
\alias{fct<-,NormType-method}

\title{Norm Type}
\description{Class of norm types.}
\section{Objects from the Class}{Could be generated by \code{new("NormType")}; more frequently one will use
the generating function \code{\link{NormType}}}
\section{Slots}{
  \describe{
    \item{\code{name}:}{Object of class \code{"character"}.}
    \item{\code{fct}:}{Object of class \code{"function"} --- the norm to be evaluated.}
  }
}
\section{Methods}{
  \describe{
    \item{name}{\code{signature(object = "NormType")}: 
      accessor function for slot \code{name}. }
    \item{name<-}{\code{signature(object = "NormType", value = "character")}: 
      replacement function for slot \code{name}. }
    \item{fct}{\code{signature(object = "NormType")}: 
      accessor function for slot \code{fct}. }
    \item{fct<-}{\code{signature(object = "NormType", value = "function")}: 
      replacement function for slot \code{fct}. }
        }
}
\references{
  Rieder, H. (1994) \emph{Robust Asymptotic Statistics}. New York: Springer.

  Kohl, M. (2005) \emph{Numerical Contributions to the Asymptotic Theory of Robustness}. 
  Bayreuth: Dissertation.
}
\author{Peter Ruckdeschel \email{Peter.Ruckdeschel@itwm.fraunhofer.de}}
%\note{}
\seealso{\code{\link{BiasType-class}}}
\examples{
EuclNorm <- NormType("EuclideanNorm",EuclideanNorm)
fct(EuclNorm)
name(EuclNorm)
}
\concept{asymptotic risk}
\concept{bias}
\concept{risk}
\keyword{classes}
