\name{distrExOptions}
\alias{distrExOptions}
%\alias{distrExoptions}
%\alias{getdistrExOption}
\alias{MCIterations}
\alias{GLIntegrateTruncQuantile}
\alias{GLIntegrateOrder}
\alias{ElowerTruncQuantile}
\alias{EupperTruncQuantile}
\alias{ErelativeTolerance}
\alias{m1dfLowerTruncQuantile}
\alias{m1dfRelativeTolerance}
\alias{m2dfLowerTruncQuantile}
\alias{m2dfRelativeTolerance}

\title{Function to change the global variables of the package `distrEx' }
\description{With \code{distrExOptions} you can inspect and change 
  the global variables of the package \pkg{distrEx}. }
\usage{distrExOptions(arg = "missing", value = -1)}
\arguments{
  \item{arg}{ the global variable to be shown or changed }
  \item{value}{ the new value of the global variable }
}
%\details{}
\value{
  \code{distrExOptions()} returns a list of the global variables.\newline
  \code{distrExOptions(arg=x)} returns the global variable \var{x}.\newline
  \code{distrExOptions(arg=x,value=y)} sets the value of the global variable \var{x} to \var{y}.
}
\section{Global Options}{
\describe{
  \item{MCIterations:}{ number of Monte-Carlo iterations used for crude 
    Monte-Carlo integration. }
  \item{GLIntegrateTruncQuantile:}{ If \code{integrate} fails and there are 
    infinite integration limits, the function \code{GLIntegrate} is 
    called inside of \code{distrExIntegrate} with the corresponding quantiles 
    \code{GLIntegrateTruncQuantile} respectively,  
    1 - \code{GLIntegrateTruncQuantile} as finite integration limits. }
  \item{GLIntegrateOrder:}{ The order used for the Gauss-Legendre integration
    inside of \code{distrExIntegrate}. }
  \item{ElowerTruncQuantile:}{ The lower limit of integration used inside of 
    \code{E} which corresponds to the \code{ElowerTruncQuantile}-quantile. }
  \item{EupperTruncQuantile:}{ The upper limit of integration used inside of 
    \code{E} which corresponds to the (1-\code{ElowerTruncQuantile})-quantile. }
  \item{ErelativeTolerance:}{ The relative tolerance used inside of \code{E}
    when calling \code{distrExIntegrate}. }
  \item{m1dfLowerTruncQuantile:}{ The lower limit of integration used inside 
    of \code{m1df} which corresponds to the \code{m1dfLowerTruncQuantile}-quantile. }
  \item{m1dfRelativeTolerance:}{ The relative tolerance used inside of \code{m1df}
    when calling \code{distrExIntegrate}. }
  \item{m2dfLowerTruncQuantile:}{ The lower limit of integration used inside 
    of \code{m2df} which corresponds to the \code{m2dfLowerTruncQuantile}-quantile. }
  \item{m2dfRelativeTolerance:}{ The relative tolerance used inside of \code{m2df}
    when calling \code{distrExIntegrate}. }
}
}
%\references{}
\author{Matthias Kohl \email{Matthias.Kohl@stamats.de}}
%\note{}
%\seealso{}
\examples{
distrExOptions()
distrExOptions("ElowerTruncQuantile")
distrExOptions("ElowerTruncQuantile", 1e-6)
# or
distrExOptions(ElowerTruncQuantile)
distrExOptions(ElowerTruncQuantile, 1e-6)
}
\keyword{misc}
