% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrapper_MixtureDistribution.R
\name{MixtureDistribution}
\alias{MixtureDistribution}
\title{Mixture Distribution Wrapper}
\value{
Returns an R6 object of class MixtureDistribution.
}
\description{
Wrapper used to construct a mixture of two or more distributions.
}
\examples{

## ------------------------------------------------
## Method `MixtureDistribution$new`
## ------------------------------------------------

MixtureDistribution$new(list(Binomial$new(prob = 0.5, size = 10), Binomial$new()),
  weights = c(0.2, 0.8)
)

## ------------------------------------------------
## Method `MixtureDistribution$pdf`
## ------------------------------------------------

m <- MixtureDistribution$new(list(Binomial$new(prob = 0.5, size = 10), Binomial$new()),
  weights = c(0.2, 0.8)
)
m$pdf(1:5)
m$pdf(1)
# also possible but unlikely to be used
m$pdf(1, 2)

## ------------------------------------------------
## Method `MixtureDistribution$rand`
## ------------------------------------------------

m <- MixtureDistribution$new(distribution = "Normal",
params = data.table::data.table(mean = 1:2), shared_params = list(sd = 1))
m$rand(5)
}
\seealso{
\code{\link{listWrappers}}

Other wrappers: 
\code{\link{Convolution}},
\code{\link{DistributionWrapper}},
\code{\link{HuberizedDistribution}},
\code{\link{ProductDistribution}},
\code{\link{TruncatedDistribution}},
\code{\link{VectorDistribution}}
}
\concept{wrappers}
\section{Super classes}{
\code{\link[distr6:Distribution]{distr6::Distribution}} -> \code{\link[distr6:DistributionWrapper]{distr6::DistributionWrapper}} -> \code{\link[distr6:VectorDistribution]{distr6::VectorDistribution}} -> \code{MixtureDistribution}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MixtureDistribution$new()}}
\item \href{#method-strprint}{\code{MixtureDistribution$strprint()}}
\item \href{#method-pdf}{\code{MixtureDistribution$pdf()}}
\item \href{#method-cdf}{\code{MixtureDistribution$cdf()}}
\item \href{#method-quantile}{\code{MixtureDistribution$quantile()}}
\item \href{#method-rand}{\code{MixtureDistribution$rand()}}
\item \href{#method-clone}{\code{MixtureDistribution$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="correlation">}\href{../../distr6/html/Distribution.html#method-correlation}{\code{distr6::Distribution$correlation()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="getParameterValue">}\href{../../distr6/html/Distribution.html#method-getParameterValue}{\code{distr6::Distribution$getParameterValue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="iqr">}\href{../../distr6/html/Distribution.html#method-iqr}{\code{distr6::Distribution$iqr()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="liesInSupport">}\href{../../distr6/html/Distribution.html#method-liesInSupport}{\code{distr6::Distribution$liesInSupport()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="liesInType">}\href{../../distr6/html/Distribution.html#method-liesInType}{\code{distr6::Distribution$liesInType()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="parameters">}\href{../../distr6/html/Distribution.html#method-parameters}{\code{distr6::Distribution$parameters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="prec">}\href{../../distr6/html/Distribution.html#method-prec}{\code{distr6::Distribution$prec()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="print">}\href{../../distr6/html/Distribution.html#method-print}{\code{distr6::Distribution$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="stdev">}\href{../../distr6/html/Distribution.html#method-stdev}{\code{distr6::Distribution$stdev()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="Distribution" data-id="summary">}\href{../../distr6/html/Distribution.html#method-summary}{\code{distr6::Distribution$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="DistributionWrapper" data-id="setParameterValue">}\href{../../distr6/html/DistributionWrapper.html#method-setParameterValue}{\code{distr6::DistributionWrapper$setParameterValue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="cf">}\href{../../distr6/html/VectorDistribution.html#method-cf}{\code{distr6::VectorDistribution$cf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="entropy">}\href{../../distr6/html/VectorDistribution.html#method-entropy}{\code{distr6::VectorDistribution$entropy()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="kurtosis">}\href{../../distr6/html/VectorDistribution.html#method-kurtosis}{\code{distr6::VectorDistribution$kurtosis()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="mean">}\href{../../distr6/html/VectorDistribution.html#method-mean}{\code{distr6::VectorDistribution$mean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="median">}\href{../../distr6/html/VectorDistribution.html#method-median}{\code{distr6::VectorDistribution$median()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="mgf">}\href{../../distr6/html/VectorDistribution.html#method-mgf}{\code{distr6::VectorDistribution$mgf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="mode">}\href{../../distr6/html/VectorDistribution.html#method-mode}{\code{distr6::VectorDistribution$mode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="pgf">}\href{../../distr6/html/VectorDistribution.html#method-pgf}{\code{distr6::VectorDistribution$pgf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="skewness">}\href{../../distr6/html/VectorDistribution.html#method-skewness}{\code{distr6::VectorDistribution$skewness()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="variance">}\href{../../distr6/html/VectorDistribution.html#method-variance}{\code{distr6::VectorDistribution$variance()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="distr6" data-topic="VectorDistribution" data-id="wrappedModels">}\href{../../distr6/html/VectorDistribution.html#method-wrappedModels}{\code{distr6::VectorDistribution$wrappedModels()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$new(
  distlist = NULL,
  weights = "uniform",
  distribution = NULL,
  params = NULL,
  shared_params = NULL,
  name = NULL,
  short_name = NULL,
  decorators = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distlist}}{\code{(list())}\cr
List of \link{Distribution}s.}

\item{\code{weights}}{\code{(character(1)|numeric())}\cr
Weights to use in the resulting mixture. If all distributions are weighted equally then
\code{"uniform"} provides a much faster implementation, otherwise a vector of length equal
to the number of wrapped distributions, this is automatically scaled internally.}

\item{\code{distribution}}{\code{(character(1))} \cr
Should be supplied with \code{params} and optionally \code{shared_params} as an alternative to \code{distlist}.
Much faster implementation when only one class of distribution is being wrapped. \code{distribution}
is the full name of one of the distributions in \code{\link[=listDistributions]{listDistributions()}}, or \code{"Distribution"} if
constructing custom distributions. See examples in \link{VectorDistribution}.}

\item{\code{params}}{\code{(list()|data.frame())} \cr
Parameters in the individual distributions for use with \code{distribution}. Can be supplied as a list,
where each element is the list of parameters to set in the distribution, or as an object
coercable to \code{data.frame}, where each column is a parameter and each row is a distribution.
See examples in \link{VectorDistribution}.}

\item{\code{shared_params}}{\code{(list())}\cr
If any parameters are shared when using the \code{distribution} constructor, this provides a much faster
implementation to list and query them together. See examples in \link{VectorDistribution}.}

\item{\code{name}}{\code{(character(1))}\cr
Optional name of wrapped distribution.}

\item{\code{short_name}}{\code{(character(1))}\cr
Optional short name/ID of wrapped distribution.}

\item{\code{decorators}}{\code{(character())} \cr
Decorators to add to the distribution during construction.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{MixtureDistribution$new(list(Binomial$new(prob = 0.5, size = 10), Binomial$new()),
  weights = c(0.2, 0.8)
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strprint"></a>}}
\if{latex}{\out{\hypertarget{method-strprint}{}}}
\subsection{Method \code{strprint()}}{
Printable string representation of the \code{MixtureDistribution}. Primarily used internally.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$strprint(n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{(integer(1))}\cr
Number of distributions to include when printing.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pdf"></a>}}
\if{latex}{\out{\hypertarget{method-pdf}{}}}
\subsection{Method \code{pdf()}}{
Probability density function of the mixture distribution. Computed by
\deqn{f_M(x) = \sum_i (f_i)(x)*w_i}
where \eqn{w_i} is the vector of weights and \eqn{f_i} are the pdfs of the wrapped
distributions.

Note that as this class inherits from \link{VectorDistribution}, it is possible to evaluate
the distributions at different points, but that this is not the usual use-case for
mixture distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$pdf(..., log = FALSE, simplify = TRUE, data = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{(numeric())} \cr
Points to evaluate the function at Arguments do not need
to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.}

\item{\code{log}}{\code{(logical(1))} \cr
If \code{TRUE} returns the logarithm of the probabilities. Default is \code{FALSE}.}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{\code{data}}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{m <- MixtureDistribution$new(list(Binomial$new(prob = 0.5, size = 10), Binomial$new()),
  weights = c(0.2, 0.8)
)
m$pdf(1:5)
m$pdf(1)
# also possible but unlikely to be used
m$pdf(1, 2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative distribution function of the mixture distribution. Computed by
\deqn{F_M(x) = \sum_i (F_i)(x)*w_i}
where \eqn{w_i} is the vector of weights and \eqn{F_i} are the cdfs of the wrapped
distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$cdf(
  ...,
  lower.tail = TRUE,
  log.p = FALSE,
  simplify = TRUE,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{(numeric())} \cr
Points to evaluate the function at Arguments do not need
to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.
@examples
m <- MixtureDistribution$new(list(Binomial$new(prob = 0.5, size = 10), Binomial$new()),
weights = c(0.2, 0.8)
)
m$cdf(1:5)}

\item{\code{lower.tail}}{\code{(logical(1))} \cr
If \code{TRUE} (default), probabilities are \code{X <= x}, otherwise, \code{P(X > x)}.}

\item{\code{log.p}}{\code{(logical(1))} \cr
If \code{TRUE} returns the logarithm of the probabilities. Default is \code{FALSE}.}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{\code{data}}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
The quantile function is not implemented for mixture distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$quantile(
  ...,
  lower.tail = TRUE,
  log.p = FALSE,
  simplify = TRUE,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{(numeric())} \cr
Points to evaluate the function at Arguments do not need
to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.}

\item{\code{lower.tail}}{\code{(logical(1))} \cr
If \code{TRUE} (default), probabilities are \code{X <= x}, otherwise, \code{P(X > x)}.}

\item{\code{log.p}}{\code{(logical(1))} \cr
If \code{TRUE} returns the logarithm of the probabilities. Default is \code{FALSE}.}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{\code{data}}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rand"></a>}}
\if{latex}{\out{\hypertarget{method-rand}{}}}
\subsection{Method \code{rand()}}{
Simulation function for mixture distributions. Samples are drawn from a mixture by first
sampling Multinomial(probs = weights, size = n), then sampling each distribution according
to the samples from the Multinomial, and finally randomly permuting these draws.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$rand(n, simplify = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{(numeric(1))} \cr
Number of points to simulate from the distribution. If length greater than \eqn{1}, then
\code{n <- length(n)},}

\item{\code{simplify}}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the return if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{m <- MixtureDistribution$new(distribution = "Normal",
params = data.table::data.table(mean = 1:2), shared_params = list(sd = 1))
m$rand(5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MixtureDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
