% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi_cost_matrix.R
\name{psi_cost_matrix}
\alias{psi_cost_matrix}
\title{Cost Matrix}
\usage{
psi_cost_matrix(dist_matrix = NULL, diagonal = TRUE)
}
\arguments{
\item{dist_matrix}{(required, numeric matrix). Distance matrix generated by \code{\link[=psi_distance_matrix]{psi_distance_matrix()}}. Default: NULL}

\item{diagonal}{(optional, logical vector). If TRUE, diagonals are included in the dynamic time warping computation. Default: TRUE}
}
\value{
numeric matrix
}
\description{
Demonstration function to compute a cost matrix from a distance matrix.
}
\examples{
#distance metric
d <- "euclidean"

#use diagonals in least cost computations
diagonal <- TRUE

#simulate two irregular time series
x <- zoo_simulate(
  name = "x",
  rows = 100,
  seasons = 2,
  seed = 1
)

y <- zoo_simulate(
  name = "y",
  rows = 80,
  seasons = 2,
  seed = 2
)

if(interactive()){
  zoo_plot(x = x)
  zoo_plot(x = y)
}

#distance matrix
dist_matrix <- psi_distance_matrix(
  x = x,
  y = y,
  distance = d
)

#cost matrix
cost_matrix <- psi_cost_matrix(
  dist_matrix = dist_matrix,
  diagonal = diagonal
)

if(interactive()){
  utils_matrix_plot(
    m = cost_matrix
    )
}
}
\seealso{
Other psi_demo: 
\code{\link{psi_auto_distance}()},
\code{\link{psi_auto_sum}()},
\code{\link{psi_cost_path}()},
\code{\link{psi_cost_path_sum}()},
\code{\link{psi_distance_lock_step}()},
\code{\link{psi_distance_matrix}()},
\code{\link{psi_equation}()}
}
\concept{psi_demo}
