% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cost_path_orthogonal_bandwidth_cpp}
\alias{cost_path_orthogonal_bandwidth_cpp}
\title{(C++) Orthogonal Least Cost Path}
\usage{
cost_path_orthogonal_bandwidth_cpp(dist_matrix, cost_matrix, bandwidth = 1)
}
\arguments{
\item{dist_matrix}{(required, numeric matrix). Distance matrix between two
time series.}

\item{cost_matrix}{(required, numeric matrix). Cost matrix generated from
\code{dist_matrix}.}

\item{bandwidth}{(required, numeric) Size of the Sakoe-Chiba band at
both sides of the diagonal used to constrain the least cost path. Expressed
as a fraction of the number of matrix rows and columns. Unrestricted by default.
Default: 1}
}
\value{
data frame
}
\description{
Computes an orthogonal least-cost path within a cost matrix. Each steps within
the least-cost path either moves in the x or the y direction, but never diagonally.
}
\examples{
#simulate two time series
x <- zoo_simulate(seed = 1)
y <- zoo_simulate(seed = 2)

#distance matrix
dist_matrix <- distance_matrix_cpp(
  x = x,
  y = y,
  distance = "euclidean"
)

#least cost matrix
cost_matrix <- cost_matrix_orthogonal_cpp(
  dist_matrix = dist_matrix
)

#least cost path
cost_path <- cost_path_orthogonal_cpp(
  dist_matrix = dist_matrix,
  cost_matrix = cost_matrix
)

cost_path
}
\seealso{
Other Rcpp_cost_path: 
\code{\link{cost_path_cpp}()},
\code{\link{cost_path_diagonal_bandwidth_cpp}()},
\code{\link{cost_path_diagonal_cpp}()},
\code{\link{cost_path_orthogonal_cpp}()},
\code{\link{cost_path_slotting_cpp}()},
\code{\link{cost_path_sum_cpp}()},
\code{\link{cost_path_trim_cpp}()}
}
\concept{Rcpp_cost_path}
