% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection.prob.R
\name{detection.prob}
\alias{detection.prob}
\title{Calculate detection probabilities.}
\usage{
detection.prob(d, detection.function = c("halfnormal", "hazard"), theta,
  deriv, stop = F)
}
\arguments{
\item{d}{The distance or distances of interest.}

\item{detection.function}{The detection function. Only "halfnormal" and "hazard" (hazard rate) are supported at present.}

\item{theta}{The detection function parameters. A single value for halfnormal, or a vector of two values for hazard rate.}

\item{deriv}{Optional numeric value specifying whether a derivative is required. If missing, the function returns the detection probabilities at distances d.
If deriv is equal to 1 or 2, the derivatives of the detection function with respect to theta[deriv] at d are returned.
Note that the halfnormal detection function has only one parameter, so setting deriv=2 and detection.function="halfnormal" will result in an error.}

\item{stop}{Set to T to open a browser window (for debugging purposes)}
}
\value{
A vector of detection probabilities corresponding to the distances in d.
}
\description{
Calculates the detection probability at one or more distances.
}
\examples{
dvalues <- seq(from=0,to=1,by=0.001)
dprobs <- detection.prob(d=dvalues,detection.function="hazard",theta=c(0.448,2))
plot(dvalues,dprobs,type="l",ylim=c(0,1))
}
\references{
Buckland S, Anderson D, Burnham K, Laake J and Borchers D (2001). Introduction to Distance Sampling: Estimating Abundance of Biological Populations. Oxford: Oxford University Press.

Clark, R. G. (2016), "Statistical efficiency in distance sampling," PLoS One, forthcoming, www.plosone.org
}

