#!perl -w

use strict;

use File::Basename;

print_header();

print_includes(@ARGV);

print_namespace_info();

print_definition_start();

print_map_contents(@ARGV);

print_finish();

sub print_header {
    print "/** auto-generated by make_all.pl **/\n";
    print "#ifndef BNT_DIFFERENCE_OPTIONS__H\n";
    print "#define BNT_DIFFERENCE_OPTIONS__H 1\n";
    print "\n";
    print "#include <map>\n";
    print "#include \"base.hpp\"\n";
    print "\n";
}

sub print_includes {
    print "#include \"$_\"\n" while(<@_>);
    print "\n";
}

sub print_namespace_info {
    print "namespace BNT {\n";
    print "\n";
    print "namespace Difference {\n";
    print "\n";
}

sub print_definition_start {
    print "template< typename K, typename T >\n";
    print "const std::map< K, Base<T>* >& make_options_map() {\n";
    print "\n";
    print "typedef typename std::map< K, Base<T>* > options_map_t;\n";
    print "\n";
    print "static options_map_t diff_options_map;\n";
    print "\n";
}

sub print_map_contents {
    while(<@_>){
	my $n = fileparse($_,"\.hpp");
	print "diff_options_map[\"", lc $n, "\"] = new $n<T>;\n"
    }
    print "\n";
}

sub print_finish {
    print "return diff_options_map;\n";
    print "}\n";
    print "}\n";
    print "}\n";
    print "\n";
    print "#endif\n";
}
