% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/disparity_filter.R
\name{get.backbone}
\alias{get.backbone}
\title{Disparity Filter Algorithm of Weighted Network}
\usage{
get.backbone(graph, alpha = 0.05, directed = FALSE)
}
\arguments{
\item{graph}{igraph graph object. The original weighted graph.}

\item{alpha}{Statistical significance level. By default is set to 0.05.}

\item{directed}{Logical, whether the network is directed or undirected. By default is set to FALSE.}
}
\description{
Disparity filter is a network reduction algorithm to extract the backbone structure of both directed and undirected weighted networks. Disparity filter can reduce the network without destroying the multi-scale nature of the network. The algorithm has been developed by M. Angeles Serrano, Marian Boguna, and Alessandro Vespignani in "Extracting the multiscale backbone of complex weighted networks", Proceedings of the national academy of sciences 106 (16).
}
\examples{
head(network)
G = graph.data.frame(network, directed = FALSE)
G_backbone = get.backbone(graph = G, alpha = 0.05, directed = FALSE)
}
\keyword{backbone}
\keyword{disparity}
\keyword{extraction}
\keyword{filter}

