% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{get.matrix}
\alias{get.matrix}
\alias{get.disparity}
\alias{matrix.dispRity}
\alias{extract.dispRity}
\title{Extract elements from a \code{dispRity} object.}
\usage{
get.matrix(data, subsets, rarefaction, bootstrap, matrix)

get.disparity(data, subsets, rarefaction, observed, concatenate)
}
\arguments{
\item{data}{A \code{dispRity} object.}

\item{subsets}{Optional, a \code{numeric} or \code{character} for which subsets to get (if missing, the value for all subsets are given).}

\item{rarefaction}{Optional, a single \code{numeric} value corresponding to the rarefaction level (as the number of elements; if missing, the non-rarefied values are output).}

\item{bootstrap}{Optional, a \code{numeric} value to select a specific bootstrap draw (\code{0} is no bootstrap).}

\item{matrix}{A \code{numeric} value of which matrix to select (default is \code{1}).}

\item{observed}{A \code{logical} value indicating whether to output the observed (\code{TRUE} (default)) or the bootstrapped values (\code{FALSE}).}

\item{concatenate}{When the disparity metric is a distribution, whether to concatenate it returning the median (\code{TRUE}; default) or to return each individual values.}
}
\description{
Extract a matrix or the disparity results from a \code{dispRity}.
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## To get the original matrix
get.matrix(disparity)

## To get the un-bootstrapped matrix from the subset called "80"
get.matrix(disparity, subsets = "80")

## To get the 52nd bootstrap draw of the second rarefaction level (15) of the
## same subset
get.matrix(disparity, subsets = 2, rarefaction = 2, bootstrap = 52)

## Extracting the observed disparity
get.disparity(disparity)

## Extracting the bootstrapped disparity
boot_disp <- get.disparity(disparity, observed = FALSE)
str(boot_disp)
## Or only the rarefied (5) data
boot_disp_rare <- get.disparity(disparity, observed = FALSE,
     rarefaction = 5)

}
\seealso{
\code{\link{dispRity}}, \code{\link{get.subsets}}.
}
\author{
Thomas Guillerme
}
