% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{rescale.dispRity}
\alias{rescale.dispRity}
\title{Rescaling and centering disparity results.}
\usage{
\method{rescale}{dispRity}(data, center = FALSE, scale = TRUE,
  use.all = TRUE, ...)
}
\arguments{
\item{data}{a \code{dispRity} object.}

\item{center}{either a \code{logical} value or a \code{numeric} vector of length equal to the number of elements of \code{data} (default is \code{FALSE}).}

\item{scale}{either a \code{logical} value or a \code{numeric} vector of length equal to the number of elements of \code{data} (default is \code{TRUE}).}

\item{use.all}{\code{logical}, whether to scale/center using the full distribution (i.e. all the disparity values) or only the distribution within each subsets of bootstraps (default is \code{TRUE}).}

\item{...}{optional arguments to be passed to \code{scale}.}
}
\description{
Scales or/and centers the disparity measurements.
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Scaling the data
summary(rescale.dispRity(disparity, scale = TRUE)) # Dividing by the maximum
## Multiplying by 10 (dividing by 0.1)
summary(rescale.dispRity(disparity, scale = 0.1))

}
\seealso{
\code{\link{dispRity}}, \code{\link{test.dispRity}}, \code{\link[base]{scale}}.
}
\author{
Thomas Guillerme
}
