% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.wrapper.R
\name{dispRity.through.time}
\alias{dispRity.through.time}
\title{Disparity through time.}
\usage{
dispRity.through.time(data, tree, time, metric = c(median, centroids),
  ...)
}
\arguments{
\item{data}{An ordinated \code{matrix}.}

\item{tree}{A \code{phylo} object.}

\item{time}{A \code{numeric} value for the number of subsets to create.}

\item{metric}{A vector containing one to three functions (default = \code{c(median, centroids)}) (see \code{\link{dispRity}} for details).}

\item{...}{Optional arguments to be passed to \code{\link{chrono.subsets}}, \code{\link{boot.matrix}} and \code{\link{dispRity}}.}
}
\value{
A \code{dispRity} object that can be passed to \code{summary} or \code{plot}.
}
\description{
Performs a disparity through time analysis.
}
\details{
By default the time subsets use \code{method = "discrete"}, the matrix is bootstrapped 100 times.

Note that this is a wrapper function that allows users to run a basic disparity-through-time analysis without too much effort. 
As such it has a lot of defaults described in the functions that make up the analysis. 
See \code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity.metric}}, \code{\link{summary.dispRity}}, \code{\link{plot.dispRity}} for more details of the defaults used in each of these functions.
Note that any of these defaults can be changed within the \code{disparity.through.time} function.
}
\examples{
## Load the Beck & Lee 2014 data
data(BeckLee_mat50) ; data(BeckLee_tree)

## Run a simple disparity through time analysis (with three time bins)
result <- dispRity.through.time(BeckLee_mat50, BeckLee_tree, 3)
summary(result) ; plot(result)

## This is equivalent to run the following decomposed code
dispRity(boot.matrix(chrono.subsets(BeckLee_mat50, BeckLee_tree, time = 3, method = "discrete"),
                     bootstraps = 100),
         metric = c(median, centroids))

}
\seealso{
\code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity.metric}}, \code{\link{summary.dispRity}}, \code{\link{plot.dispRity}}.
}
\author{
Thomas Guillerme
}
