% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claddis.ordination.R
\name{Claddis.ordination}
\alias{Claddis.ordination}
\title{Imports data from Claddis}
\usage{
Claddis.ordination(data, distance = "MORD", ..., k, add = TRUE,
  arg.cmdscale)
}
\arguments{
\item{data}{Data from Claddis::ReadMorphNexus.}

\item{distance}{Distance type to be computed by \code{\link[Claddis]{MorphDistMatrix}}. Can be either \code{"GC"}, \code{"GED"}, \code{"RED"}, \code{"MORD"}}

\item{...}{Any optional arguments to be passed to \code{\link[Claddis]{MorphDistMatrix}}.}

\item{k}{The number of dimensions in the ordination. If left empty, the number of dimensions is set to number of rows - 1.}

\item{add}{whether to use the Cailliez correction for negative eigen values (\code{add = TRUE}; default - see \code{\link[stats]{cmdscale}}) or not (\code{add = FALSE}).}

\item{arg.cmdscale}{Any optional arguments to be passed to \code{\link[stats]{cmdscale}} (as a named list such as \code{list(x.ret = TRUE)}).}
}
\description{
Takes Claddis data and computes both the distance and the ordination matrix
}
\examples{
\dontrun{
require(Claddis)

## Creating an ordination of the distance matrix of Claddis example data
Claddis.ordination(Michaux1989)
}

}
\seealso{
\code{\link[Claddis]{MorphDistMatrix}}, \code{\link[Claddis]{ReadMorphNexus}}, \code{\link[Claddis]{MakeMorphMatrix}}, \code{\link[stats]{cmdscale}}, \code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}.
}
\author{
Thomas Guillerme
}
