# Author: Robert Hijmans
# November 2009
# License GPL3

# First versions were based on the rollFun function implemented by Diethelm Wuertz in the 
# fTrading package # Version: 2100.76 # Published:	2009-09-29


movingFun <- function(x, n, fun=function(x){mean(x, na.rm=TRUE)}, type='around', circular=FALSE)  { 
	n <- round(abs(n))
    if (n == 0) { stop('n == 0')  }
    x = as.vector(x)
	lng <- length(x)
	if (type == 'around') {
		hn <- floor(n/2)
		if (circular) {	x <- c(x[(lng-hn+1):lng], x, x[1:hn])
		} else { x <- c(rep(NA, hn), x, rep(NA, hn)) }
	} else if (type == 'to') {
		if (circular) { x <- c(x[(lng-n+2):lng], x)
		} else { x <- c(rep(NA, n-1), x) }
	} else if (type == 'from') {
		if (circular) { x <- c(x,  x[1:n])
		} else { x <- c(x, rep(NA, n))	}
	} else {
		stop('unknown type; should be "around", "to", or "from"')
	}
	m <- matrix(ncol=n, nrow=lng)
    for (i in 1:n) { m[,i] <- x[i:(lng+i-1)] }
    apply(m, MARGIN=1, FUN=fun)
}

