% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.r
\name{setup_disk.frame}
\alias{setup_disk.frame}
\title{Set up disk.frame environment}
\usage{
setup_disk.frame(workers = parallel::detectCores(logical = FALSE),
  future_backend = future::multiprocess, ..., gui = FALSE)
}
\arguments{
\item{workers}{the number of workers (background R processes in the}

\item{future_backend}{which future backend to use for parallelization}

\item{...}{passed to `future::plan`}

\item{gui}{Whether to use a Graphical User Interface (GUI) for selecting the options. Defaults to FALSE}
}
\description{
Set up disk.frame environment
}
\examples{
if (interactive()) {
  # setup disk.frame to use multiple workers these may use more than two
  # cores, and is therefore not allowed on CRAN. Hence it's set to run only in
  # interactive session
  setup_disk.frame()
  
  # use a Shiny GUI to adjust settings
  # only run in interactive()
  setup_disk.frame(gui = TRUE)
}

# set the number workers to 2
# only run this interatively
setup_disk.frame(2)

# if you do not wish to use multiple workers you can set it to sequential
setup_disk.frame(future_backend=future::sequential)
}
