% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_cluster_utils.R
\name{hc_radar}
\alias{hc_radar}
\title{Radar representation for centers of clusters.}
\usage{
hc_radar(centros, nombre.archivo, colores = NULL)
}
\arguments{
\item{centros}{a data.frame object with the centers of the clusters.}

\item{nombre.archivo}{a character value specifying the name to use when the plot is downloaded.}

\item{colores}{a vector of color for each cluster.}
}
\value{
Highchart plot
}
\description{
Radar representation for centers of clusters.
}
\examples{
clusters <- factor(kmeans(iris[, -5], 3)$cluster)
c <- calc.centros(iris[, -5], clusters)
hc_radar(c$porcentual, 'radar', c("steelblue", "pink", "forestgreen"))

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
