% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R
\name{categories}
\alias{categories}
\alias{category}
\alias{category_latest_topics}
\alias{category_top_topics}
\alias{category_new_topics}
\alias{category_create}
\title{Work with categories}
\usage{
categories(url = NULL, key = NULL, user = NULL, ...)

category(category, url = NULL, key = NULL, user = NULL, ...)

category_latest_topics(category, url = NULL, key = NULL, user = NULL, ...)

category_top_topics(category, url = NULL, key = NULL, user = NULL, ...)

category_new_topics(category, url = NULL, key = NULL, user = NULL, ...)

category_create(category, color, text_color, description = NULL,
  permissions = NULL, parent_category = NULL, url = NULL, key = NULL,
  user = NULL, ...)
}
\arguments{
\item{url}{Base url for a Discourse installation. See 
\code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}

\item{category}{Category name. required}

\item{color}{A color by name or hex string. optional}

\item{text_color}{A color by name or hex string. optional}

\item{description}{Description of the category. optional}

\item{permissions}{Permissions - a list with the group name and permission_type
which is an integer: 1 = Full, 2 = Create Post, 3 = Read Only. optional}

\item{parent_category}{x. optional}
}
\description{
Work with categories
}
\details{
Apprently there's no ability to delete categories via the API.
}
\examples{
\dontrun{
# all categories
categories()

# a specfic category
category("questions")
category("packages")

# latest topics for a category
category_latest_topics("packages")

# top topics for a category
category_top_topics("packages")

# new topics for a category
category_new_topics("packages")

# create a category
category_create("stuff3", "F7941D", "FFFFFF", "My new category")
}
}
