% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoStepsBenchmark.R
\name{residuals_extrap}
\alias{residuals_extrap}
\title{Extrapolation function for the residuals in a twoStepsBenchmark}
\usage{
residuals_extrap(lfresiduals, rho, include.differenciation)
}
\arguments{
\item{lfresiduals}{the residuals to extrapolate}

\item{rho}{the autocorrelation parameter of the regression}

\item{include.differenciation}{a boolean, the same as submitted
to twoStepsBenchmark}

\item{n}{an integer, how many extrapolations to do.}
}
\value{
a numeric, the extrapolated sequence of residuals, to replace the NA of
the residuals
}
\description{
This function is the rule to extrapolate the low-frequency residuals
If include.differenciation is true, u(n+1)-u(n) = rho*(u(n)-u(n-1))
Else u(n+1) = rho * u(n)
}
\keyword{internal}
