% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-flex-div.R
\name{flex_div}
\alias{flex_div}
\title{Generate Shiny element with arrangement automatically}
\usage{
flex_div(..., ncols = "auto")
}
\arguments{
\item{...}{shiny UI elements}

\item{ncols}{number of columns, either \code{"auto"} or
vector of positive integers}
}
\value{
HTML objects
}
\description{
Generate Shiny element with arrangement automatically
}
\details{
If multiple numbers of columns are specified,
\code{flex_div} will guess the best size that will be applied.
For button UI, \code{flex_div} automatically add \code{"20px"}
on the top margin.
}
\examples{
ui <- flex_div(
  shiny::selectInput('sel', label = 'Select input',
                     choices = '', width = '100\%'),
  shiny::textInput('id2', label = html_asis(' '), width = '100\%',
                   value = 'Heights aligned'),
  actionButtonStyled('ok2', 'Button', width = '100\%',),
  shiny::sliderInput('sl', 'Item 4', min = 1, max = 2,
                     value = 1.5, width = '100\%'),
  shiny::fileInput('aa', 'item 5', width = '100\%'),
  ncols = c(2,3) # Try to assign 2 or 3 items per column
)
if(interactive()){
  shiny::shinyApp(ui = shiny::fluidPage(shiny::fluidRow(ui)),
                  server = function(input, output, session){})
}
}
