% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{new_function2}
\alias{new_function2}
\title{Create new function that supports 'quasi-quosure' syntax}
\usage{
new_function2(
  args = alist(),
  body = { },
  env = parent.frame(),
  quote_type = c("unquoted", "quote", "quo"),
  quasi_env = parent.frame()
)
}
\arguments{
\item{args}{named list of function formals}

\item{body}{function body expression, supports 'quasi-quosure' syntax}

\item{env}{declare environment of the function}

\item{quote_type}{character, whether \code{body} is unquoted, quoted,
or a \code{\link[rlang]{quo}} object}

\item{quasi_env}{where the 'quasi-quosure' should be evaluated,
default is parent environment}
}
\value{
a function
}
\description{
Create new function that supports 'quasi-quosure' syntax
}
\details{
An unquoted body expression will be quoted, all the
expressions with 'quasi-quosure' like \code{!!var} will be evaluated
and substituted with the value of \code{var}. For a 'quosure',
\code{\link[rlang]{quo_squash}} will be applied. A quoted
expression will not be substitute, but will be expanded if any
'quasi-quosure' detected

\code{args} must be a \code{list} object, see \code{\link{formals}}.
For arguments with no default values, or quoted defaults, use
\code{\link{alist}}. An \code{arg=alist(a=)} will result in a
function like \code{function(a){...}}. See examples for more details.
}
\examples{

# ------------ standard usage ------------
x <- 1:10
f1 <- new_function2(alist(a=), { print(a + x) })
f1(0)

x <- 20:23
f1(0)  # result changed as x changed

# ------------ 'quasi-quosure' syntax ------------
x <- 1:10
f2 <- new_function2(alist(a=), { print(a + !!x) })
print(f2)

f2(0)

x <- 20:23
f2(0)  # result doesn't change as f2 doesn't depend on x anymore

# ------------ argument settings ------------

default <- 123

# default with values pre-specified
new_function2(list(a = default))   # function (a = 123){}

# default with values unevaluated
new_function2(list(a = quote(default)))   # function (a = default){}
new_function2(alist(a = default))

# missing default
new_function2(alist(a = ))    # function (a){}


}
\seealso{
\code{\link[rlang]{quo}}, \code{\link[rlang]{new_function}}
}
