% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-setInputs.R
\name{set_shiny_input}
\alias{set_shiny_input}
\title{Set Shiny Input}
\usage{
set_shiny_input(
  session,
  inputId,
  value,
  priority = c("event", "deferred", "immediate"),
  method = c("proxy", "serialize", "value", "expression"),
  quoted = TRUE
)
}
\arguments{
\item{session}{shiny session, see shiny \code{\link[shiny]{domains}}}

\item{inputId}{character, input ID}

\item{value}{the value to assign}

\item{priority}{characters, options are "event", "deferred", and "immediate".
"event" and "immediate" are similar, they always fire changes. "deferred"
fire signals to other reactive/observers only when the input value has been
changed}

\item{method}{characters, options are "proxy", "serialize", "value",
"expression". "proxy" is recommended, other methods are experimental.}

\item{quoted}{is value quoted? Only used when method is "expression"}
}
\description{
Shiny `input' object is read-only reactive list. When try to
assign values to input, errors usually occur. This method provides several
work-around to set values to input.
}
