% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dilp_functions.R
\name{dilp}
\alias{dilp}
\title{Generate DiLP results}
\usage{
dilp(specimen_data, params = "PeppeGlobal", subsite_cols = NULL)
}
\arguments{
\item{specimen_data}{A data frame containing specimen level leaf physiognomic
data. See Lowe et al. 2024 for more information on how to collect this data.
A good reference for how to put together the data: \code{\link{McAbeeExample}}

Required columns:
\itemize{
\item site
\item specimen_number
\item morphotype
\item margin
\item feret
\item blade_area
\item raw_blade_perimeter
\item internal_raw_blade_perimeter
\item length_of_cut_perimeter
\item no_primary_teeth
\item no_of_subsidiary_teeth
}

Recommended columns:
\itemize{
\item petiole_width
\item petiole_area
\item blade_perimeter
\item minimum_feret
\item raw_blade_area
\item internal_raw_blade_area
}}

\item{params}{Either a string referring to one of two preloaded parameter sets
of a list of custom parameters (same format as the list below).

Preloaded parameter sets are "global" and "northern_hemisphere" which are calibrated based on
global and northern hemisphere data respectively. Allen et al. (2020) illustrates a situation
in which the northern hemisphere parameters may be preferable.  The "northern_hemisphere" parameters
only estimate MAT.  Use "global" for all MAP estimates. Defaults to "global" as follows (Peppe et al. 2011):
\itemize{
\item MAT.MLR.M = 0.21,
\item MAT.MLR.FDR = 42.296,
\item MAT.MLR.TC.IP = -2.609,
\item MAT.MLR.constant = -16.004,
\item MAT.MLR.error = 4,
\item MAT.SLR.M = 0.204,
\item MAT.SLR.constant = 4.6,
\item MAT.SLR.error = 4.9,
\item MAP.MLR.LA = 0.298,
\item MAP.MLR.TC.IP = 0.279,
\item MAP.MLR.PR = -2.717,
\item MAP.MLR.constant = 3.033,
\item MAP.MLR.SE = 0.6,
\item MAP.SLR.LA = 0.283,
\item MAP.SLR.constant = 2.92,
\item MAP.SLR.SE = 0.61
}}

\item{subsite_cols}{A vector or list of columns present in \code{specimen_data} to calculate
paleoclimate estimates for.  A completely optional parameter - allows different groupings of
specimens to be tested, or comparisons of paleoclimate estimates at different levels of grouping.
Adds additional estimates to $results.}
}
\value{
A list of tables that includes all pertinent DiLP
information:
\itemize{
\item processed_leaf_data: the full set of cleaned and newly calculated leaf
physiognomic data that is necessary for DiLP analysis. See \code{\link[=dilp_processing]{dilp_processing()}}
for more information.
\item processed_morphotype_data: morphospecies-site pair means for all leaf
physiognomic data.
\item processed_site_data: site means for all leaf physiognomic data.
\item errors: lists any specimens that may be causing common errors in DiLP
calculations. See \code{\link[=dilp_errors]{dilp_errors()}} for more information.
\item outliers: flags outliers in variables used for DiLP analysis that may
represent incorrect data.  See \code{\link[=dilp_outliers]{dilp_outliers()}} for more information.
\item results: climate reconstructions of MAT and MAP using single and multi-linear
regressions.
}
}
\description{
\code{dilp()} processes raw leaf physiognomic data, checks for common
errors/outliers, and returns the processed data, keys to finding potential
errors or outliers, and paleoclimate reconstructions.
}
\examples{
dilp_results <- dilp(McAbeeExample)
dilp_results$processed_leaf_data
dilp_results$processed_morphotype_data
dilp_results$processed_site_data
dilp_results$errors
dilp_results$outliers
dilp_results$results
}
\references{
\itemize{
\item Allen, S. E., Lowe, A. J., Peppe, D. J., & Meyer, H. W. (2020). Paleoclimate and paleoecology of the latest Eocene Florissant flora of central Colorado, USA. Palaeogeography, Palaeoclimatology, Palaeoecology, 551, 109678.
\item Peppe, D.J., Royer, D.L., Cariglino, B., Oliver, S.Y., Newman, S., Leight, E., Enikolopov, G., Fernandez-Burgos, M., Herrera, F., Adams, J.M., Correa, E., Currano, E.D., Erickson, J.M., Hinojosa, L.F., Hoganson, J.W., Iglesias, A., Jaramillo, C.A., Johnson, K.R., Jordan, G.J., Kraft, N.J.B., Lovelock, E.C., Lusk, C.H., Niinemets, Ü., Peñuelas, J., Rapson, G., Wing, S.L. and Wright, I.J. (2011), Sensitivity of leaf size and shape to climate: global patterns and paleoclimatic applications. New Phytologist, 190: 724-739. https://doi.org/10.1111/j.1469-8137.2010.03615.x
\item Lowe. A.J., Flynn, A.G., Butrim, M.J., Baumgartner, A., Peppe, D.J., and Royer, D.L. (2024), Reconstructing terrestrial paleoclimate and paleoecology with fossil leaves using Digital Leaf Physiognomy and leaf mass per area.  JoVE.
}
}
