% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffeqr.R
\name{dae.solve}
\alias{dae.solve}
\title{Solve Differential-Algebraic Equations (DAE)}
\usage{
dae.solve(f, du0, u0, tspan, p = NULL, alg = "nothing", reltol = 0.001,
  abstol = 1e-06, saveat = NULL, differential_vars = NULL)
}
\arguments{
\item{f}{the implicit ODE function.}

\item{du0}{the initial derivative. Can be a number or (arbitrary dimension) array.}

\item{u0}{the initial condition. Can be a number or (arbitrary dimension) array.}

\item{tspan}{the timespan to solve over. Should be a list of two values: (initial time, end time).}

\item{p}{the parameters. Defaults to no parameters. Can be a number or an array.}

\item{alg}{the algorithm used to solve the differential equation. Defaults to an adaptive choice.
Algorithm choices are done through a string which matches the DifferentialEquations.jl form.}

\item{reltol}{the relative tolerance of the ODE solver. Defaults to 1e-3.}

\item{abstol}{the absolute tolerance of the ODE solver. Defaults to 1e-6}

\item{saveat}{the time points to save values at. Should be an array of times. Defaults to automatic.}

\item{differential_vars}{boolean array declaring which variables are differential. All falses correspond to
purely algebraic variables.}
}
\value{
sol. Has the sol$t for the time points and sol$u for the values.
}
\description{
Solves a DAE with f(du,u,p,t)=0 for u(0)=u0 over the tspan
}
\examples{

\donttest{ ## diffeq_setup() is time-consuming and requires Julia+DifferentialEquations.jl

diffeqr::diffeq_setup()

f <- function (du,u,p,t) {
  resid1 = - 0.04*u[1]              + 1e4*u[2]*u[3] - du[1]
  resid2 = + 0.04*u[1] - 3e7*u[2]^2 - 1e4*u[2]*u[3] - du[2]
  resid3 = u[1] + u[2] + u[3] - 1.0
  c(resid1,resid2,resid3)
}
u0 = c(1.0, 0, 0)
du0 = c(-0.04, 0.04, 0.0)
tspan = list(0.0,100000.0)
differential_vars = c(TRUE,TRUE,FALSE)
sol = diffeqr::dae.solve(f,du0,u0,tspan,differential_vars=differential_vars)
udf = as.data.frame(sol$u)
#plotly::plot_ly(udf, x = sol$t, y = ~V1, type = 'scatter', mode = 'lines') \%>\%
#plotly::add_trace(y = ~V2) \%>\%
#plotly::add_trace(y = ~V3)

f = JuliaCall::julia_eval("function f(out,du,u,p,t)
  out[1] = - 0.04u[1]              + 1e4*u[2]*u[3] - du[1]
  out[2] = + 0.04u[1] - 3e7*u[2]^2 - 1e4*u[2]*u[3] - du[2]
  out[3] = u[1] + u[2] + u[3] - 1.0
end")
sol = diffeqr::dae.solve('f',du0,u0,tspan,differential_vars=differential_vars)

}

}
