% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{predict.ddfMLR}
\alias{predict.ddfMLR}
\title{Predicted values for an object of \code{"ddfMLR"} class.}
\usage{
\method{predict}{ddfMLR}(object, item = "all", match, group, ...)
}
\arguments{
\item{object}{an object of \code{"ddfMLR"} class.}

\item{item}{numeric or character: either character \code{"all"} to
apply for all converged items (default), or a vector of item
names (column names of \code{Data}), or item identifiers
(integers specifying the column number).}

\item{match}{numeric: matching criterion for new observations.}

\item{group}{numeric: group membership for new observations.}

\item{...}{other generic parameters for \code{predict()} function.}
}
\description{
S3 method for predictions from the model used in the
  object of \code{"ddfMLR"} class.
}
\examples{
\dontrun{
# loading data
data(GMATtest, GMATkey)
Data <- GMATtest[, 1:20] # items
group <- GMATtest[, "group"] # group membership variable
key <- GMATkey # correct answers

# testing both DDF effects
(x <- ddfMLR(Data, group, focal.name = 1, key))

# fitted values
predict(x, item = 1)

# predicted values
predict(x, item = 1, match = 0, group = c(0, 1))
predict(x, item = x$DDFitems, match = 0, group = c(0, 1))
}

}
\references{
Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression models for DIF and DDF detection.
The R Journal, 12(1), 300--323, \doi{10.32614/RJ-2020-014}.
}
\seealso{
\code{\link[difNLR]{ddfMLR}} for DDF detection among nominal data using multinomial log-linear regression model. \cr
\code{\link[stats]{predict}} for generic function for prediction.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
