% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difORD.R
\name{plot.difORD}
\alias{plot.difORD}
\title{ICC plots for an object of \code{"difORD"} class.}
\usage{
\method{plot}{difORD}(x, item = "all", plot.type, group.names, ...)
}
\arguments{
\item{x}{an object of \code{"difORD"} class.}

\item{item}{numeric or character: either character \code{"all"} to apply for all converged items (default),
or a vector of item names (column names of \code{Data}), or item identifiers (integers specifying
the column number).}

\item{plot.type}{character: which plot should be displayed for cumulative logit regression model. Either
\code{"category"} (default) for category probabilities or \code{"cumulative"} for cumulative probabilities.}

\item{group.names}{character: names of reference and focal group.}

\item{...}{other generic parameters for \code{plot()} function.}
}
\value{
Returns list of objects of class \code{"ggplot"}.
}
\description{
Plot method for an object of \code{"difORD"} class using \pkg{ggplot2}.

The characteristic curves (category probabilities) for an item specified in \code{item}
argument are plotted. Plotted curves represent the best model. For cumulative logit model,
also cumulative probabilities may be plotted.
}
\examples{
\dontrun{
# Loading data
data(dataMedicalgraded, package = "ShinyItemAnalysis")
Data <- dataMedicalgraded[, 1:5]
group <- dataMedicalgraded[, 101]

# Testing both DIF effects with adjacent category logit model
(x <- difORD(Data, group, focal.name = 1, model = "adjacent"))

# Graphical devices
plot(x, item = 3)
plot(x, item = "X2003", group.names = c("Group 1", "Group 2"))

# Testing both DIF effects with cumulative logit model
(x <- difORD(Data, group, focal.name = 1, model = "cumulative"))
plot(x, item = 3, plot.type = "cumulative")
plot(x, item = 3, plot.type = "category")
}
}
\seealso{
\code{\link[difNLR]{difORD}} for DIF detection among ordinal data. \cr
\code{\link[ggplot2]{ggplot}} for general function to plot a \code{"ggplot"} object.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
