% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{predict.difNLR}
\alias{predict.difNLR}
\title{Predicted values for \code{"difNLR"} object.}
\usage{
\method{predict}{difNLR}(object, item = "all", match, group, ...)
}
\arguments{
\item{object}{an object of \code{"difNLR"} class.}

\item{item}{numeric or character: either character \code{"all"} to apply for all converged items (default),
or a vector of item names (column names of \code{Data}), or item identifiers (integers specifying
the column number).}

\item{match}{numeric: matching criterion for new observations.}

\item{group}{numeric: group membership for new observations.}

\item{...}{other generic parameters for \code{predict()} function.}
}
\description{
Predicted values based on \code{"difNLR"} object.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

Data <- GMAT[, 1:20]
group <- GMAT[, "group"]

# Testing both DIF effects using likelihood-ratio test and
# 3PL model with fixed guessing for groups
(x <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))

# Predicted values
predict(x)
predict(x, item = 1)
predict(x, item = "Item1")

# Predicted values for new observations - average score
predict(x, item = 1, match = 0, group = 0) # reference group
predict(x, item = 1, match = 0, group = 1) # focal group

# Predicted values for new observations - various z-scores
predict(x, item = 1, match = c(-1, 0, 1), group = 0) # reference group
predict(x, item = 1, match = c(-1, 0, 1), group = 1) # focal group
}

}
\references{
Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517,
\url{https://doi.org/10.1111/jedm.12158}.

Swaminathan, H. & Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures.
Journal of Educational Measurement, 27(4), 361-370,
\url{https://doi.org/10.1111/j.1745-3984.1990.tb00754.x}
}
\seealso{
\code{\link[difNLR]{difNLR}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
