% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSATB.R
\docType{data}
\name{MSATB}
\alias{MSATB}
\title{Dichotomous Data Set of Medical School Admission Test in Biology}
\format{A \code{MSATB} data frame consists of 1,407 observations on the following
21 variables. The first 20 columns represent dichotomously scored items of the test.
The 21st column is vector of group membership; values 0 and 1 refer to males (reference group)
and females (focal group).}
\usage{
data(MSATB)
}
\description{
The \code{MSATB} data set consists of the responses of 1,407 subjects
(484 males, 923 females) to admission test to medical school in Czech republic.
It contains 20 selected items from original test while first item was previously detected
as differently functioning (Vlckova, 2014). A correct answer is coded as 1 and incorrect
answer as 0. The column \code{gender} represents gender of students, where 0 represents
males (reference group) and 1 represents females (focal group).
}
\references{
Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517,
\url{https://doi.org/10.1111/jedm.12158}.

Vlckova, K. (2014). Test and Item Fairness (Unpublished master's thesis).
}
\seealso{
\code{\link{MSATBtest}}, \code{\link{MSATBkey}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
\keyword{datasets}
