////////////////////////////////////////////////////////////////////////////////
//
// DgOutPtsText.cpp: DgOutPtsText class implementation
//
// Version 6.1 - Kevin Sahr, 5/23/13
//
////////////////////////////////////////////////////////////////////////////////

#include <list>
#include <sstream>

#include "DgOutPtsText.h"
#include "DgLocList.h"
#include "DgPolygon.h"
#include "DgLocation.h"
#include "DgCell.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
DgOutPtsText::DgOutPtsText (const DgRFBase& rfIn, const string& fileNameIn, 
                          int precision, DgReportLevel failLevel)
   : DgOutLocTextFile (fileNameIn, rfIn, true, "txt", precision, failLevel)
{
   if (rfIn.vecAddress(DgDVec2D(M_ZERO, M_ZERO)) == 0)
   {
      DgOutputStream::report("DgOutPtsText::DgOutPtsText(): RF " + rfIn.name() +
             " must override the vecAddress() method", DgBase::Fatal);
   }

   setFormatStr();

} // DgOutPtsText::DgOutPtsText

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
DgOutLocFile&
DgOutPtsText::insert (const DgDVec2D& pt)
//
// Put the point pt.
//
////////////////////////////////////////////////////////////////////////////////
{
   const int maxBuffSize = 200;
   char buff[maxBuffSize];

   sprintf(buff, formatStr(), pt.x(), pt.y());

   *this << buff;

   return *this;

} // DgOutLocFile& DgOutPtsText::insert

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
DgOutLocFile&
DgOutPtsText::insert (DgLocation& loc, const string* label)
//
// Put the point loc.
//
////////////////////////////////////////////////////////////////////////////////
{
   rf().convert(&loc);

   if (label)
     *this << *label << ",";
   else
     *this << "0,";

   this->insert(rf().getVecLocation(loc));

   return *this;

} // DgOutLocFile& DgOutPtsText::insert

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
DgOutLocFile&
DgOutPtsText::insert (DgLocVector& vec, const string* label, 
                     const DgLocation* cent)
//
// Put the polyline vec.
//
////////////////////////////////////////////////////////////////////////////////
{
   DgOutputStream::report("DgOutPtsText::insert(DgLocVector): not defined.", DgBase::Fatal);
   return *this;

} // DgOutLocFile& DgOutPtsText::insert

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
DgOutLocFile&
DgOutPtsText::insert (DgPolygon& poly, const string* label, 
                     const DgLocation* cent)
//
// Put the polygon poly.
//
////////////////////////////////////////////////////////////////////////////////
{
   DgOutputStream::report("DgOutPtsText::insert(DgPolygon): not defined.", DgBase::Fatal);
   return *this;

   return *this;

} // DgOutLocFile& DgOutPtsText::insert

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
