% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggridR.R
\name{dgsetres}
\alias{dgsetres}
\title{Set the resolution of a dggs object}
\usage{
dgsetres(dggs, res)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct().}

\item{res}{Resolution. Must be in the range [0,30]. Larger values represent
finer resolutions. Appropriate resolutions can be found with
dg_closest_res_to_area(), dg_closest_res_to_spacing(), and
dg_closest_res_to_cls(). Default is 9, which corresponds to a
cell area of ~2600 sq km and a cell spacing of ~50 km.
Default: 9.}
}
\value{
Returns a dggs object which can be passed to other dggridR
            functions
}
\description{
Set the resolution of a dggs object
}
\examples{
library(dggridR)
dggs <- dgconstruct(res=20)
dggs <- dgsetres(dggs,10)

}
