% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2yaml.R
\name{df2yaml2}
\alias{df2yaml2}
\title{Convert dataframe to YAML.}
\usage{
df2yaml2(
  df,
  key_col = c("paras", "subcmd"),
  val_col = "values",
  val_sep = ";",
  key_sep = ":",
  out_yaml = NULL
)
}
\arguments{
\item{df}{Dataframe.}

\item{key_col}{The columns used as keys, up to 2.}

\item{val_col}{The columns used as values, this column can contain key: value pairs.}

\item{val_sep}{The separator used to seperate different key:value pairs in \code{val_col}. Default: ";".}

\item{key_sep}{The separator used to seperate key and value. Default: ":".}

\item{out_yaml}{The output yaml file. Default: NULL (string).}
}
\value{
NULL (write YAML) or string (if \code{out_yaml} is NULL).
}
\description{
Convert dataframe to YAML.
}
\examples{
library(df2yaml)
test_file <- system.file("extdata", "df2yaml_l3.txt", package = "df2yaml")
test_data <- read.table(file = test_file, header = TRUE, sep = "\t")
df2yaml(df = test_data, key_col = c("paras", "subcmd"), val_col = "values")
}
