% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2yaml.R
\name{df2yaml}
\alias{df2yaml}
\title{Convert dataframe to YAML.}
\usage{
df2yaml(
  df,
  key_col,
  val_col,
  val_sep = ";",
  key_sep = ":",
  rm_quote = TRUE,
  out_yaml = NULL
)
}
\arguments{
\item{df}{Dataframe.}

\item{key_col}{The columns used as keys.}

\item{val_col}{The columns used as values, this column can contain key: value pairs.}

\item{val_sep}{The separator used to seperate different key:value pairs in \code{val_col}. Default: ";".}

\item{key_sep}{The separator used to seperate key and value. Default: ":".}

\item{rm_quote}{Logical value, whether to remove single quotes. Default: TRUE.}

\item{out_yaml}{Output YAML file. Default: NULL (return string).}
}
\value{
NULL (write YAML) or string (if \code{out_yaml} is NULL).
}
\description{
Convert dataframe to YAML.
}
\examples{
library(df2yaml)
test_file <- system.file("extdata", "df2yaml_l3.txt", package = "df2yaml")
test_data <- read.table(file = test_file, header = TRUE, sep = "\t")
df2yaml(df = test_data, key_col = c("paras", "subcmd"), val_col = "values")
}
