% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3c.R
\name{create3DC}
\alias{create3DC}
\title{Create a database for the 3DC standard setting application}
\usage{
create3DC(export_name)
}
\arguments{
\item{export_name}{path to a new 3DC database}
}
\value{
a handle to the 3DC sqlite database
}
\description{
Creates an empty database for 3DC standard setting application
}
\details{
The data driven direct concensus (3DC) method of standard setting  is described in Keuning et. al. (2017).
To easily apply this procedure, we advise to use the free digital 3DC application. This application 
can be downloaded from the Cito website, see the 
\href{http://www.cito.com/our-expertise/implementation/3dc}{3DC application download page}. 
The functions create3DC and add_test3DC can be used to produce a standard setting database that 
can be imported in the 3DC application.

If you want to apply the 3DC method using paper forms instead, you can use the function plot3DC to generate the forms
from the 3DC database.
}
\examples{
\dontrun{
library(dplyr)
db = start_new_project(verbAggrRules, "verbAggression.db")

add_booklet(db, verbAggrData, "aggression")

par = fit_enorm(db) 
pv = plausible_values(db, par)
mu = mean(pv$PV1)
sigma = sd(pv$PV1)

# We'll use the behavior an item depicts as a basis for making the clusters,
# thus creating clusters of similar items. 

design = data.frame(item_id = verbAggrProperties$item_id, 
   cluster = verbAggrProperties$behavior)

# specify the actual sample for display in the group_leader page

population = get_testscores(db) \%>\% 
                group_by(test_score) \%>\% 
                summarise(frequency=n()) 

db3dc = create3DC('test3DC.db')

add_test3DC(db3dc, parms=par, design, mu=mu, sigma=sigma, 
            test_id='verbal_aggression', standards='verbally aggressive',
            population=population)

#get a preview
plot3DC(db3dc)


dbDisconnect(db3dc)
close_project(db)
}

}
\references{
Keuning J., Straat J.H., Feskens R.C.W. (2017) The Data-Driven Direct Consensus (3DC) Procedure: A New Approach to Standard Setting. 
In: Blömeke S., Gustafsson JE. (eds) Standard Setting in Education. 
Methodology of Educational Measurement and Assessment. Springer, Cham
}
