% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{add_item_properties}
\alias{add_item_properties}
\title{Add item properties to a project}
\usage{
add_item_properties(db, item_properties, overwrite = TRUE,
  default_values = list())
}
\arguments{
\item{db}{A handle to the database, e.g. the output of \code{start_new_project}
or \code{open_project}}

\item{item_properties}{A data frame containing the item properties. See details.}

\item{overwrite}{Whether existing item properties should be overwritten (default=TRUE)}

\item{default_values}{a list where the names are item_properties and the values are defaults.
The defaults will be used as the value for an item for which the property is not specified, 
for example when you add new items using \code{\link{touch_rules}}.
Default_values for an item property will only be processed
the first time you define an item property.}
}
\value{
nothing
}
\description{
Adds item properties to an existing database
}
\details{
When entering response data in the form of a rectangular person x item
table, it is easy to provide person properties but practically impossible
to provide item properties. This function provides a possibility to do so.
The order of the rows and columns in the data frame is not important but
there must be a column called \code{item_id} containing the item id's
exactly as entered before.

Note that is is not possible to add new items with this function, 
use \code{\link{touch_rules}} if you want to add new items to your project.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", 
  covariates=list(gender="<unknown>"))
head(verbAggrProperties)
add_item_properties(db, verbAggrProperties)
get_item_properties(db) 

close_project(db)
}

}
\seealso{
\code{\link{fit_domains}}, \code{\link{profile_plot}} for
 possible uses of item_properties
}
