% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enorm.R
\name{fit_enorm}
\alias{fit_enorm}
\title{Fit the extended nominal response model}
\usage{
fit_enorm(dataSrc, predicate = NULL, fixed_params = NULL,
  method = c("CML", "Bayes"), nIterations = 500)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{fixed_params}{Optionally, a prms object from a previous analysis or 
a data.frame with columns: item_id, item_score (omitting 0 score category) and beta}

\item{method}{If CML, the estimation method will be Conditional Maximum Likelihood;
otherwise, a Gibbs sampler will be used to produce a sample from the posterior}

\item{nIterations}{Number of Gibbs samples when method is Bayes, max. number of iterations 
when method is CML}
}
\value{
An object of type \code{prms}. The prms object can be cast to a data.frame of item parameters 
using the \code{as.data.frame} built-in function or used directly as input for other Dexter functions.
}
\description{
Fits the extended nominal response model by Bayesian sampling or CML
}
\seealso{
functions that accept a prms object as input: \code{\link{ability}}, \code{\link{plausible_values}}
}
