% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\alias{check_built}
\title{Build and check a package, cleaning up automatically on success.}
\usage{
check(
  pkg = ".",
  document = NULL,
  build_args = NULL,
  ...,
  manual = FALSE,
  cran = TRUE,
  remote = FALSE,
  incoming = remote,
  force_suggests = FALSE,
  run_dont_test = FALSE,
  args = "--timings",
  env_vars = c(NOT_CRAN = "true"),
  quiet = FALSE,
  check_dir = tempdir(),
  cleanup = TRUE,
  vignettes = TRUE,
  error_on = c("never", "error", "warning", "note")
)

check_built(
  path = NULL,
  cran = TRUE,
  remote = FALSE,
  incoming = remote,
  force_suggests = FALSE,
  run_dont_test = FALSE,
  manual = FALSE,
  args = "--timings",
  env_vars = NULL,
  check_dir = tempdir(),
  quiet = FALSE,
  error_on = c("never", "error", "warning", "note")
)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{document}{By default (\code{NULL}) will document if your installed
roxygen2 version matches the version declared in the \code{DESCRIPTION}
file. Use \code{TRUE} or \code{FALSE} to override the default.}

\item{build_args}{Additional arguments passed to \verb{R CMD build}}

\item{...}{Additional arguments passed on to \code{\link[pkgbuild:build]{pkgbuild::build()}}.}

\item{manual}{If \code{FALSE}, don't build and check manual
(\code{--no-manual}).}

\item{cran}{if \code{TRUE} (the default), check using the same settings as
CRAN uses.}

\item{remote}{Sets \verb{_R_CHECK_CRAN_INCOMING_REMOTE_} env var.
If \code{TRUE}, performs a number of CRAN incoming checks that require
remote access.}

\item{incoming}{Sets \verb{_R_CHECK_CRAN_INCOMING_} env var.
If \code{TRUE}, performs a number of CRAN incoming checks.}

\item{force_suggests}{Sets \verb{_R_CHECK_FORCE_SUGGESTS_}. If
\code{FALSE} (the default), check will proceed even if all suggested
packages aren't found.}

\item{run_dont_test}{Sets \code{--run-donttest} so that tests surrounded in
\verb{\\dontest\{\}} are also tested. When \code{cran = TRUE}, this only affects
R 3.6 and earlier; in R 4.0.0 code in \verb{\\dontest\{\}} is always run as
part of CRAN submission.}

\item{args}{Character vector of arguments to pass to
\code{R CMD check}. (Note that instead of the \code{--output} option you
should use the \code{check_dir} argument, because  \code{--output} cannot
deal with spaces and other special characters on Windows.}

\item{env_vars}{Environment variables set during \verb{R CMD check}}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{check_dir}{the directory in which the package is checked
compatibility. \code{args = "--output=/foo/bar"} can be used to change the
check directory.}

\item{cleanup}{Deprecated.}

\item{vignettes}{If \code{FALSE}, do not build or check vignettes, equivalent to
using \verb{args = '--ignore-vignettes' and }build_args = '--no-build-vignettes'.}

\item{error_on}{Whether to throw an error on \code{R CMD check} failures.
Note that the check is always completed (unless a timeout happens),
and the error is only thrown after completion. If \code{"never"}, then
no errors are thrown. If \code{"error"}, then only \code{ERROR} failures
generate errors. If \code{"warning"}, then \code{WARNING} failures generate
errors as well. If \code{"note"}, then any check failure generated an
error.}

\item{path}{Path to built package.}
}
\value{
An object containing errors, warnings, and notes.
}
\description{
\code{check} automatically builds and checks a source package, using all
known best practices. \code{check_built} checks an already built package.
}
\details{
Passing \verb{R CMD check} is essential if you want to submit your package
to CRAN: you must not have any ERRORs or WARNINGs, and you want to ensure
that there are as few NOTEs as possible.  If you are not submitting to CRAN,
at least ensure that there are no ERRORs or WARNINGs: these typically
represent serious problems.

\code{check} automatically builds a package before calling \code{check_built}
as this is the recommended way to check packages.  Note that this process
runs in an independent realisation of R, so nothing in your current
workspace will affect the process.
}
\section{Environment variables}{


Devtools does its best to set up an environment that combines best practices
with how check works on CRAN. This includes:

\itemize{

\item The standard environment variables set by devtools:
\code{\link[=r_env_vars]{r_env_vars()}}. Of particular note for package tests is the
\code{NOT_CRAN} env var which lets you know that your tests are not
running on CRAN, and hence can take a reasonable amount of time.

\item Debugging flags for the compiler, set by
\code{\link{compiler_flags}(FALSE)}.

\item If \code{aspell} is found \verb{_R_CHECK_CRAN_INCOMING_USE_ASPELL_}
is set to \code{TRUE}. If no spell checker is installed, a warning is
issued.)

\item env vars set by arguments \code{incoming}, \code{remote} and
\code{force_suggests}
}
}

\seealso{
\code{\link[=release]{release()}} if you want to send the checked package to
CRAN.
}
