% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectMaxChange.R
\name{detectMaxChange}
\alias{detectMaxChange}
\title{Change point detection using max-type statistic as in Jeong et. al (2016)}
\usage{
detectMaxChange(
  Y,
  m = c(30, 40, 50),
  margin = 30,
  thre.localfdr = 0.2,
  design.mat = NULL,
  plotTF = TRUE,
  n.cl
)
}
\arguments{
\item{Y}{Input data matrix}

\item{m}{window sizes}

\item{margin}{margin}

\item{thre.localfdr}{threshold for local fdr}

\item{design.mat}{design matrix for analyzing task data}

\item{plotTF}{Draw plot to see test statistic and threshold}

\item{n.cl}{number of clusters for parallel computing}
}
\value{
\strong{CLX} Test statistic correspoding to window size arranged in column

\strong{CLXLocalFDR} The Local FDR calculated for each time point

\strong{br} The final estimated break points
}
\description{
Change point detection using max-type statistic as in Jeong et. al (2016)
}
\examples{
\donttest{out2= detectMaxChange(changesim, m=c(30, 35, 40, 45, 50), n.cl=1)}
}
