% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quincunx.R
\name{quincunx}
\alias{quincunx}
\title{Quincunx simulation}
\usage{
quincunx(n = 3, numballs = 20, delay = 0.1, probright = 0.5,
  plottrue = TRUE)
}
\arguments{
\item{n}{Integer The number of peg levels, default is 3}

\item{numballs}{Integer The number of balls dropped, default is 20}

\item{delay}{Numeric Number of seconds between ball drops. Set
delay > 0 to see animation with \code{delay} seconds between
dropped balls. If \code{delay < 0}, the simulation will run to
completion without delays. If \code{delay == 0}, the user must
hit <return> for the next ball to drop. The default is 0.1 second
and can be set with the \code{delay} parameter.}

\item{probright}{Numeric The probability the ball bounces to the
right; default is 0.5}

\item{plottrue}{Boolean If \code{TRUE}, the display will indicate
bin levels if the distribution were normal. Default is TRUE}
}
\description{
\code{quincunx} simulates balls dropping down a
pegboard with a 50\% chance of bouncing right or left at each
level. The balls accumulate in bins. If enough balls are dropped,
the distribution approaches normality. This device is called a
quincunx. See \url{http://www.mathsisfun.com/data/quincunx.html}
}
\examples{

## These examples will not display correctly within RStudio unless
## the plot window is large
quincunx(delay=0)
quincunx(n=10, numballs=200, delay=0)
quincunx(n=20, numballs=200, delay=0, probright=0.7)

}

