% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_sets.R
\docType{data}
\name{pkg_sets}
\alias{pkg_sets}
\alias{pkg_misc}
\alias{pkg_utils}
\alias{pkg_speed}
\alias{pkg_mlt}
\alias{pkg_stat}
\alias{pkg_stan}
\alias{pkg_devel}
\alias{pkg_docs}
\alias{pkg_prod}
\alias{pkg_all}
\title{Packages' sets}
\format{
An object of class \code{character} of length 3.

An object of class \code{character} of length 4.

An object of class \code{character} of length 4.

An object of class \code{character} of length 6.

An object of class \code{character} of length 7.

An object of class \code{character} of length 2.

An object of class \code{character} of length 12.

An object of class \code{character} of length 4.

An object of class \code{character} of length 4.

An object of class \code{character} of length 44.
}
\usage{
pkg_misc

pkg_utils

pkg_speed

pkg_mlt

pkg_stat

pkg_stan

pkg_devel

pkg_docs

pkg_prod

pkg_all
}
\description{
These are presets of packages which can be used to easily prepare
systems installing them in groups or all together (using `pkg_all`).
}
\details{
Packages imported by the mentioned packages are not included into
the sets (that is the reason why, e.g., you do not see `{shiny}` or
`knitr`, ...).
}
\section{Functions}{
\itemize{
\item \code{pkg_misc}: Packages for side-interest purposes, including
`{beepr}`, `{fortunes}`, and `{telegram.bot}`.

\item \code{pkg_utils}: Utilities for data analyses, including `{here}`,
`{lobstr}`, `{progress}`, and `{tidyverse}`.

\item \code{pkg_speed}: Are you in a hurry?! This includes `{furrr}`,
`{parallel}`, `snow`, and `{tidyfast}`.

\item \code{pkg_mlt}: Machine Learning in R (we do not include
`{keras}` nor `{tensorflow}` which require _ad hoc_ configuration).
 This includes `{caret}`, `{glmnet}`, `{mlr3}`, `{snow}`,
 `{tidymodels}`, `{tidytext}`, and `{tm}`.

\item \code{pkg_stat}: (Clinical oriented) statistical analyses in R.
This includes `{CBPS}`, `{cobalt}`, `{MatchIt}`, `{mice}`, `{rms}`,
`{twang}`, and `{WeightIt}`.

\item \code{pkg_stan}: Stan analyses in R (Alert: these packages
require `stan` be installed into the system. They are not included
into `pkg_all`). This includes `{rstanarm}`, and `{brms}`.

\item \code{pkg_devel}: Develop stuff in R. This includes `{assertive}`,
`{covr}`, `{lintr}`, `{fs}`, `{profvis}`, `{pryr}`, `{renv}`,
`{roxygen2}`, `{styler}`, `{testthat}`, `{spelling}`, and
`{usethis}`.

\item \code{pkg_docs}: Write and render things in R. This includes
`{blogdown}`, `{DT}`, `{pander}`, and `{pkgdown}`.

\item \code{pkg_prod}: for develop and put in production stuffs
(`{shiny}` app included). This includes `{golem}`, `{docopt}`,
`{plumbr}`, and `{shinyjs}`.

\item \code{pkg_all}: Union of the `pkg_misc`, `pkg_utils`, `pkg_speed`,
`pkg_mlt`, `pkg_stat`, `pkg_devel`, `pkg_docs`, and `pkg_prod`
 pkg_* sets.
}}

\seealso{
install_pkg_set
}
\keyword{datasets}
