% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTransfoCompRisks.R
\name{likF.cmprsk.Cholesky}
\alias{likF.cmprsk.Cholesky}
\title{Wrapper implementing likelihood function using Cholesky factorization.}
\usage{
likF.cmprsk.Cholesky(par.chol, data, admin, conf, cf, eps = 0.001)
}
\arguments{
\item{par.chol}{Vector of all second step model parameters, consisting of the
regression parameters, Cholesky decomposition of the variance-covariance
matrix elements and transformation parameters.}

\item{data}{Data frame resulting from the 'uniformize.data.R' function.}

\item{admin}{Boolean value indicating whether the data contains
administrative censoring.}

\item{conf}{Boolean value indicating whether the data contains confounding
and hence indicating the presence of Z and W.}

\item{cf}{"Control function" to be used. This can either be the (i) estimated
control function, (ii) the true control function, (iii) the instrumental
variable, or (iv) nothing (\code{cf = NULL}). Option (ii) is used when
comparing the two-step estimator to the oracle estimator, and option (iii) is
used to compare the two-step estimator with the naive estimator.}

\item{eps}{Minimum value for the diagonal elements in the covariance matrix.
Default is \code{eps = 0.001}.}
}
\value{
Log-likelihood evaluation of the second step.
}
\description{
This function parametrizes the covariance matrix using its
Cholesky decomposition, so that optimization of the likelihood can be done
based on this parametrization, and positive-definiteness of the covariance
matrix is guaranteed at each step of the optimization algorithm.
}
