% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_step_sampler.R
\name{denoiseq}
\alias{denoiseq}
\title{Differential expression analysis using a bottom-up model}
\usage{
denoiseq(RDobject, steps, tuningSteps = floor(steps/3))
}
\arguments{
\item{RDobject}{A readsData object.}

\item{steps}{An integer representing the number of iterations.}

\item{tuningSteps}{An integer representing the number of iterations to be
used for tuning the step sizes. Defaulted to a third of steps.}
}
\value{
The same readsData object but with a filled output slot. The output slot now contains  2 lists, i.e samples which contains
 posterior  samples  for each of the parameters  \code{N_i}, \code{p} and \code{f}, and
 stepsize which  contains the tuned step sizes.
}
\description{
The denoiseq function perfoms default analysis by first normalising the counts and then estimating the model
parameters using Bayesian inference. Size factors are estimated from count matrix and used for the normalisation.
The  Gibb's sampling algorithm is then used to sample from the joint posterior distribution of the model parameters.
}
\details{
The denoiSeq package is based on a bottom-up model for PCR sequencing developed by Ndifon et al. (2012). The model
generates, in a bottom-up manner, a probability distribution for the final copy number of a gene, which is in
the form of a superposition of the negative binomial and the binomial distributions.  The derived distribution has three main
parameters, i.e \code{N, p} and \code{f} , which represent the initial gene
amount before amplification, the amplification efficiency and the dilution rate, respectively.

Bayesian inference is used to estimate the model parameters. The counts in each column are used to estimate the size factors (Anders and Huber,2010) which are
in turn used to normalise the counts. For an m by n matrix, inference aims at estimating the three sets of parameters, i.e \code{p, f} and \code{N_i} ’s (2m in total
because we are considering 2 conditions with the same m genes in each).
denoiseq  uses the
rows in each condition to estimate parameter N_i for each gene in that condition, and uses the
entire dataset, combined from both conditions,  to estimate \code{p} and
\code{f}.

For differential expression analysis, the primary parameters of interest are \eqn{N_iA} and \code{N_iB} (from conditions A and B respectively), for each gene i.
}
\examples{
#pre -filtering to remove lowly expressed genes
ERCC <- ERCC[rowSums(ERCC)>0,]
RD <- new('readsData',counts = ERCC)
steps <- 30
#30 steps are just for illustration here. Atleast 5000 steps are adequate.
BI <- denoiseq(RD,steps)

}
