% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbranch.R
\name{collapse_branch}
\alias{collapse_branch}
\title{Collapse branches under a tolerance level}
\usage{
collapse_branch(dend, tol = 1e-08, lower = TRUE, ...)
}
\arguments{
\item{dend}{dendrogram object}

\item{tol}{a numeric value giving the tolerance to consider a branch length significantly greater than zero}

\item{lower}{logical (TRUE). collapse branches which are lower than tol?}

\item{...}{passed on (not used)}
}
\value{
A dendrogram with both of the root's branches of the same height
}
\description{
Collapse branches under a tolerance level
}
\examples{

# # ladderize is like sort(..., type = "node")
dend <- iris[1:5,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram 
par(mfrow = c(1,3))
dend \%>\% ladderize \%>\% plot(horiz = TRUE); abline(v = .2, col = 2, lty = 2)
dend \%>\% collapse_branch(tol = 0.2) \%>\% ladderize \%>\% plot(horiz = TRUE)
dend \%>\% collapse_branch(tol = 0.2) \%>\% ladderize \%>\% 
      hang.dendrogram(hang = 0) \%>\% plot(horiz = TRUE)

par(mfrow = c(1,2))
dend \%>\% collapse_branch(tol = 0.2, lower = FALSE) \%>\% plot(horiz = TRUE, main = "dendrogram")
library(ape)
dend \%>\% as.phylo \%>\% di2multi(tol = 0.2) \%>\% plot(main = "phylo")
}
\seealso{
\link[ape]{multi2di}
}

