% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distinct_edges.R
\name{dist.dendlist}
\alias{dist.dendlist}
\title{Topological Distances Between Two dendrograms}
\usage{
dist.dendlist(dend, method = c("edgeset"), ...)
}
\arguments{
\item{dend}{a \link{dendlist}}

\item{method}{currently only 'edgeset' is implemented.}

\item{...}{Ignored.}
}
\value{
A \link{dist} object with topological distances between all trees
}
\description{
This function computes the Robinson-Foulds distance (also known as symmetric difference)
between two dendrograms. This is the sum of edges in both trees with labels that exist in
only one of the two trees (i.e.: the length of \link{distinct_edges}).

This function might implement other topological distances in the future.
}
\examples{
x <- 1:5 \%>\% dist \%>\% hclust \%>\% as.dendrogram
y <- set(x, "labels", 5:1)

dist.dendlist(dendlist(x1 = x,x2 = x,y1 = y))
dend_diff(x,y)
}
\seealso{
\link{distinct_edges},
\link[ape]{dist.topo},
\link[distory]{dist.multiPhylo},
\link[phangorn]{treedist},
}

