% Generated by roxygen2 (4.0.2): do not edit by hand
\name{branches_attr_by_clusters}
\alias{branches_attr_by_clusters}
\title{Change col/lwd/lty of branches based on clusters}
\usage{
branches_attr_by_clusters(dend, clusters, values, attr = c("col", "lwd",
  "lty"), ...)
}
\arguments{
\item{dend}{a dendrogram dend}

\item{clusters}{an integer vector of clusters.
This HAS to be of the size of the number of leaves.
Items that belong to no cluster should get the value 0.
The vector should be of the same order as that of the labels in the dendrogram.
If you create the clusters from something like \link{cutree} you would first
need to use \link{order.dendrogram} on it, before using it in the function.}

\item{values}{the attributes to use for non 0 values.
This should be of the same length as the number of non-0 clusters.
If it is not, it is recycled.}

\item{attr}{a character with one of the following values: col/lwd/lty}

\item{...}{ignored.}
}
\value{
A dendrogram with modified branches (col/lwd/lty).
}
\description{
The user supplies a dend, a vector of clusters, and what to modify (and how).

And the function returns a dendrogram with branches col/lwd/lty accordingly.
(the function assumes unique labels)
}
\details{
This is probably NOT a very fast implementation of the function, but it works.

This function was designed to enable the manipulation (mainly coloring) of
branches, based on the results from the \link[dynamicTreeCut]{cutreeDynamic}
function.
}
\examples{
\dontrun{

### Getting the hc object
iris_dist <- iris[,-5] \%>\% dist
hc <-  iris_dist \%>\% hclust
# This is how it looks without any colors:
dend <- as.dendrogram(hc)
plot(dend)

# Both functions give the same outcome
# options 1:
dend \%>\% set("branches_k_color", k = 4) \%>\% plot
# options 2:
clusters <- cutree(dend, 4)[order.dendrogram(dend)]
dend \%>\% branches_attr_by_clusters(clusters) \%>\% plot

# and the second option is much slower:
system.time(set(dend, "branches_k_color", k = 4)) # 0.26 sec
system.time(branches_attr_by_clusters(dend, clusters)) # 1.61 sec
# BUT, it also allows us to do more flaxible things!

#--------------------------
#   Plotting dynamicTreeCut
#--------------------------

# let's get the clusters
library(dynamicTreeCut)
clusters <- cutreeDynamic(hc, distM = as.matrix(iris_dist))
# we need to sort them to the order of the dendrogram:
clusters <- clusters[order.dendrogram(dend)]

# get some functions:
library(dendextendRcpp)
library(colorspace)
no0_unique <- function(x) {
   u_x <- unique(x)
   u_x[u_x != 0]
}

clusters_numbers <- no0_unique(clusters)
n_clusters <- length(clusters_numbers)
cols <- rainbow_hcl(n_clusters)
dend2 <- branches_attr_by_clusters(dend, clusters, values = cols)
# dend2 <- branches_attr_by_clusters(dend, clusters)
plot(dend2)
# add colored bars:
ord_cols <- rainbow_hcl(n_clusters)[order(clusters_numbers)]
tmp_cols  <- rep(1, length(clusters))
tmp_cols[clusters != 0] <- ord_cols[clusters != 0][clusters]
colored_bars(tmp_cols, y_shift = -1.1, rowLabels = "")
# all of the ordering is to handle the fact that the cluster numbers are not ascending...

# How is this compared with the usual cutree?
dend3 <- color_branches(dend, k = n_clusters)
labels(dend2) <- as.character(labels(dend2))
# this needs fixing, since the labels are not character!
# Well, both cluster solutions are not perfect, but at least they are interesting...
 tanglegram(dend2, dend3,
            main_left = "cutreeDynamic", main_right = "cutree",
            columns_width = c(5,.5,5),
            color_lines = cols[iris[order.dendrogram(dend2),5]])
# (Notice how the color_lines is of the true Species of each Iris)
# The main difference is at the bottom,

}
}
\seealso{
\link{branches_attr_by_labels},
\link{get_leaves_attr}, \link{nnodes}, \link{nleaves}
\link[dynamicTreeCut]{cutreeDynamic},
\link[WGCNA]{plotDendroAndColors}
}

