% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DropoutMechanism.R
\name{DropoutMechanism.object}
\alias{DropoutMechanism.object}
\alias{print.DropoutMechanism}
\title{DropoutMechanism object}
\arguments{
\item{type}{The type of mechanism (e.g. "MCAR" or "MNAR")}

\item{text}{A short string describing the mechanism (only used for printing)}

\item{cols.needed}{Which columns in the SingleSim$data data frame must be included for this
drop out mechanism to work. This option could allow drop out mechanism which depend on covariates to be
included.}

\item{GetDropTime}{A function with two arguments event.times and data, the corresponding entries from the 
SingleSim object. This function should return a list of dropout times (if a subject does not dropout its dropout time should be 
their current censored.time (i.e. the study follow up time))}

\item{parameters}{A list of named parameters for the mechanism (only used for printing) or NULL if none}
}
\description{
An object which defines a specific mechanism which  
takes a complete \code{SingleSim} object and returns
a set of drop out times for subjects
}
\details{
It is possible to create user defined mechanisms, however, certain
common mechanisms have already been implemented. For example see
\code{\link{ConstantRateDrop}} and \code{\link{LinearRateChangeDrop}}

Only the GetDropTime and cols.needed entries are required for
calculation, the other entries are used for printing the object 

\code{print.DropoutMechanism} methods is defined.
}
\section{Structure}{
 The following components must be included in
a DropoutMechanism Object
}

