% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleSim.R
\name{SimulateComplete}
\alias{SimulateComplete}
\title{Simulate a complete data set}
\usage{
SimulateComplete(study.time, dejaData = NULL, number.subjects = NULL,
  event.rates = NULL, dispersions)
}
\arguments{
\item{study.time}{The study follow up period}

\item{dejaData}{If not NULL this should contain a \code{DejaData} object. If this is used then
number.subjects and event.rates arguments are ignored}

\item{number.subjects}{The number of subjects, if a vector \code{c(a,b)} then
\code{a} subjects on the control arm and \code{b} subjects on the active arm. If 
\code{number.subjects} is a single number then both arms have the given number of subjects.}

\item{event.rates}{The rate parameter(s) for the negative binomial model (if single parameter then it is used for both arms)}

\item{dispersions}{The dispersion parameter(s) for the negative binomial model (if single parameter then it is used for both arms)}
}
\value{
A \code{SingleSim} object with \code{status='complete'}
}
\description{
Simulate a complete data set of a recurrent event
clinical trial without dropouts using a negative binomial model
with given rates and dispersion parameters
}
\details{
Each subject's events are described by a Poisson process with a subject specific rate given by
\code{lambda/study.time} where \code{study.time} is the study follow up period and \code{lambda}
has a gamma distribution with \code{shape=1/dispersion} and \code{scale=dispersion*event.rate*study.time}

Different dispersions, event.rates and number of subjects can be specified for both arms of the trial
}
\examples{
sim <- SimulateComplete(study.time=365,number.subjects=50,
                        event.rates=c(0.01,0.005),dispersions=0.25)
sim2 <- SimulateComplete(study.time=365,number.subjects=c(50,75),
                        event.rates=c(0.01,0.005),dispersions=c(0,0.25))
}
\seealso{
\code{\link{SingleSim.object}}
}
